; Datei: rs232inc_header.asm
; Behandlung der seriellen Schnittstelle
; Header-Datei
; ***********************
; ** I N T E R F A C E **
; ***********************
;
; benutzt das Modul "arithmetik.asm"
;
; UPR-Name		used Registers	ch	calls	affects	Beschreibung
;				in		out
; serinit		-		-							Initialisieren der RS232 mit 9600,8,k,1
; v24_test		-		-					  temp1	Sendet permanent "U" = 0x55 -> halbe Baudrate
; serout		temp1	temp1	n				-	Zeichen ausgeben
; serin			-		temp1	j				-	Zeichen einlesen
; serin_echo	-		temp1	j	serout		-	Zeichen mit Echo einlesen
; v24_LF		-		-		n	serout		-	Zeilenvorschub ausgeben
; v24_CR		-		-		n	serout		-	Wagenrcklauf ausgeben
; v24_LFCR		-		-		n	serout		-	Zeilenvorschub und Wagenrcklauf ausgeben
; v24_CD		-		-		n	serout		-	Clear Display ausgeben
; v24_in_hex	-		temp1	j	serin		-	Zwei Zeichen als Hexziffern fr ein Byte in temp1
; v24_in_number	-		temp1	j	serin		R1	Zwei Ziffern als Zehnerziffern fr ein Byte in temp1
; v24_number	temp1	temp1	n	serout		-	Zahl in temp1 ausgeben
; v24_number_hextemp1	temp1	n	serout		-	Zahl in temp1 als Hexadecimalzahl ausgeben
; v24_flash_str temp1	temp1	n	serout		-	0-term. String aus Flashmemory ausgeben
; v24_read_int	-		-		j	serin	  R2:R8	Ganzzahl <= 16,7 Mio einlesen (3-Byte)
; 									addbtemp1
;									bmal10
; v24_binout	temp2	-		n	serout		-	3-Byte-Zahl in Akku B ausgeben
;				Akku B			n	bin2asc		-			
; v24_eep_strin	temp1	temp1	j	eep_read	-	0-term. String aus dem EEPROM ausgeben	
;									serout
; eep_serout	temp1	temp2	j	eep_read	-	Byte von Adresse in temp1(/temp2) aus dem EEPROM ausgeben
;	an EEPROM-Umfang anpassen!!!
; ****************************************************************************************************
;
	.equ baud = 9600  	; Baudrate
	.equ ubrr_val = ((takt+baud*8)/(baud*16)-1)		; clever Runden
	.equ baud_real = (takt/(16*(ubrr_val+1)))		; tatschliche Baudrate
	.equ baud_error = ((baud_real*1000)/baud-1000)	; Fehler in Promille

	.def accu1 = r1			; Einlesen von 2-stelligen Zahlen 

;
;
.if ((baud_error> 10) || (baud_error <-10))		; max +/- 10 Promill Fehler
	.error "Systematischer Fehler der Baudrate grer als 1 Prozent und damit zu hoch!"
.else
	.message "Systematischer Fehler der Baudrate hlt sich in Grenzen - OK!"
.endif
;
	.equ CR = 0x0D
	.equ LF = 0x0A
	.equ CD = 0x0C		; Werte zur Terminalsteuerung
