; ********************************************************************
; Routinen zum EEPROM-Zugriff
; Datei: eeprom_512_inc.asm
; ********************************************************************
; ********************************************************************
; Interface
; ********************************************************************
; ********************************************************************
; eep_read 		Adresse in temp1 (Lowbyte) und temp2 (Highbyte)
;				Byterckgabe in temp1 
;				temp2 wird nicht verndert
; eep_write		Adresse in temp2 (Lowbyte) und temp3 (Highbyte)
;				Bytewert in temp1
;
;
;
	; Byte aus dem EEPROM lesen, Adresse in temp1, temp2
eep_read:
	sbic eecr, eewe					; noch ein Schreibzugriff laufend?
	rjmp eep_read					; dann warten
	cli								; jetzt keine IRQs mehr
	out  eearl, temp1				; EEP-Adresse an EEP-Adressregister
	out  eearh, temp2
	sbi  eecr, eere					; Fr Lesebefehl Bit setzen
	in	 temp1, eedr				; von eeprom einlesen
	sei								; Ab jetzt knnen IRQ wieder bearbeitet werden
	ret								; zurck aus der Subroutine

	; Byte in temp1 in EEPROM an Adresse in temp2,temp3 schreiben
eep_write:
	sbic eecr, eewe					; noch ein Schreibzugriff laufend?
	rjmp eep_write					; dann warten
	cli
	out  eearl, temp2				; EEP-Adresse an EEP-Adressregister
	out  eearh, temp3
	out  eedr, temp1				; Datenbyte ins EEPROM Datenregister schreiben
	sbi  eecr, eemwe				; Masterbit fr Schreibzugriff setzen
	sbi  eecr, eewe					; Byte in EEPROM schreiben
	sei
	ret	
	
