; Datei: arithmetik_header.asm
; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; Ganzzahlarthmetik mit den Registern 
; R2 : Stellenanzahl beim Dividieren
; R6 : Stellenzhler beim Multiplizieren
; R3,4,5 : Akkumulator B
; R6,7,8 : Akkumulator A
; R2,3,4,5: Ergebnis bei 16-Bit-Multiplikation
; Weiter werden __keine__ Register verndert
; kleinster Wert 0
; maximaler Wert 256^3 -1 = 16.777.215 bei Addition, Subtraktion und Division
; maximaler Wert 256^4 -1 = 4.294.967.295 bei Multiplikation
;
; Interface
; ================================================================
; bmal10: Multipliziert die Zahl in Akku B mit 10
; bmal2:  Multipliziert die Zahl in Akku B mit 2
; addba:  Addiert die Akkuinhalte A und B -> B
; addbtemp1: Addiert den Inhalt von temp1 mit Akku B
; bdiva: akku b enthlt den dividenden dann den quotienten
	; akku a enthlt den divisor und dann den rest
	; die register r9:r11 dienen als zwischenspeicher (keine Vernderung)
	; r2 ist der Zhler fr die durchgnge
	; R2 wird aus temp2 geladen, das die anzahl zu verarbeitender Stellen vorgibt
; asc2bin: erzeugt aus einer HEX-Ziffer den Nibble-wert
	; bergabe in temp2 als Ascii
	; rckgabe in temp2	als hexwert (lownibble)
; ascnib: erzeugt aus einem Hex-Nibble das zugehrige Ascii-Zeichen
	; bergabe im Lownibble von temp1 als hex-wert
	; rckgabe in temp1 als ascii-zeichen
; ascbyte: macht aus einem Byte (Hexwert in temp1) zwei Ascii-Zeichen
	; Rckgabe in temp1:temp2 (H;L)
; bin2asc: akku b enthlt die dazustellende Zahl (3 Bytes) oder den quotienten
	; akku a enthlt nach dem Divisionsaufruf im lowbyte den 10er-Rest
	; Die Zahl wird in einen 0-terminierten ascii-string transformiert
	; und in buffer abgelegt. Die niederwertigste Ziffer steht am Anfang!
	; die Anzahl von Stellen (ohne die Schluss-Null) wird in temp2 zurckgegeben
; mulx16		Softwaremultiplikation R5:R4:R3:R2 <-  R25:R24 * R23:R22
;									   MSB  :  LSB <-  MSB:LSB * MSB:LSB
; divbr2_1024	Softwaredivision R5:R4:R3 <- R5:R4:R3:R2 / 1024 


;
; ================================================================
; 
	.def stellen = r2		; Zhler fr eingegebene Zeichen im Zeichen-Buffer
	.def lb = r3
	.def mb = r4
	.def hb = r5			; Akkubytes fr die Verarbeitung von Ganzzahlen
	.def la = r6
	.def ma = r7
	.def ha = r8			; Akkubytes fr die Verarbeitung von Ganzzahlen

	.def akkub_l = r3
	.def akkub_m = r4
	.def akkub_h = r5
	.def akkua_l = r6
	.def akkua_m = r7
	.def akkua_h = r8
;
.dseg

buffer: .byte 20				; Eingabepuffer im SRAM-Bereich
;
