; Testprogramm und Bibliothek fr AD-Wandlung
; AVR: ATMEGA8
;
;
; Anschlsse und Portbelegung fr ATmega8
; =========================================
; Port -> Pin -> Pollinboard Expansionport
;.equ pc0 = 0; ADC0 = pin 23 
;.equ pc1 = 1; ADC1 = pin 24 
;.equ pc2 = 2; ADC2 = pin 25 
;.equ pc3 = 3; ADC3 = pin 26 
;.equ pc4 = 4; ADC4 = pin 27 
;.equ pc5 = 5; ADC5 = pin 28 
;              AREF = pin 21
;			   AVCC = pin 20
;
;********************************************
;** Analog Comparator und Analog Converter **
;********************************************
;
;ADC Data Register
; ADCL, ADCH: zuerst Low, dann High lesen!

;ADC Control und Status Register A 
;***************************************************************************
;               7		6		5		4		3		2		1		0
; ADCSRA	;  ADEN	|  ADSC	| ADATE	| ADIF	| ADIE	|  ADPS2 | ADPS1 | ADPS0
;	ADEN = 	ADC Enable
;	ADSC = 	ADC Start Conversion
;	ADATE=	ADC Automatic Trigger Enable (Triggert an positiver Flanke an (ADTS)
;	ADIF =	ADC Interrupt Flag (set on "Conversion complete")
;	ADIE =	ADC Interrupt Enable Bit
;	ADPSX=	ADC Prescaler Select
;			0	0	0	2
;			0	0	1	2
;			0	1	0	4
;			0	1	1	8
;			1	0	0	16
;			1	0	1	32
;			1	1	0	64
;			1	1	1	128

;
;ADC Control und Status Register A (ATmega8)
;***************************************************************************
;               7		6		5		4		3		2		1		0
; ADCSRA	;  ADEN	|  ADSC	| ADFR	| ADIF	| ADIE	|  ADPS2 | ADPS1 | ADPS0
;	ADEN = 	ADC Enable
;	ADSC = 	ADC Start Conversion
;	ADFR=	ADC Free Running
;	ADIF =	ADC Interrupt Flag (set on "Conversion complete")
;	ADIE =	ADC Interrupt Enable Bit
;	ADPSX=	ADC Prescaler Select (siehe oben)
;	ADPSX=	ADC Prescaler Select
;			0	0	0	2
;			0	0	1	2
;			0	1	0	4
;			0	1	1	8
;			1	0	0	16
;			1	0	1	32
;			1	1	0	64
;			1	1	1	128
;
;
;Analog Comparator Control und Status Register 
;***************************************************************************
;               7		6		5		4		3		2		1		0
; ACSR		;  ACD  |  ACBG	| ACO	| ACI	| ACIE	|  -	 | ACIS1 | ACIS0
;	ACD   = Analog Comparator Disable ( auf 1 setzen, falls unbentzt -> Strom sparen)
;	ACBG  = Analog Comparator Bandgap Select
;	ACO   = Analog Comparator Output
;	ACI   = Analog Comparator Interrupt Flag
;	ACIE  = Analog Comparator Interrupt Enable
;	ACISX = Analog Comparator Interrupt Mode Select
;			0	0	IRQ on Output Toggle
;			0	1	-
;			1	0	IRQ on falling Output Edge
;			1	1	IRQ on rising Output edge

;Digital Input Disable Register0
;***************************************************************************
; DIDR0		;  - 	|  -	| ADC0D	| ADC2D	| ADC3D	|  ADC0D | AIN1D | AIN0D
;	ADCXD = Digital Input Disable (auf 1 setzen, falls Digitaleingang unbenutzt)
;	AINXD = AIN0/1 Digital Input Disable (auf 1 setzen, falls Digitaleingang 
;										  unbenutzt -> Strom sparen)
;
;
;ADC Multiplexer Selection Register (ATmega8)
;***************************************************************************
; ADMUX		; REFS1 | REFS0 | ADLAR	| -		| MUX3	|  MUX2	 |  MUX1 | MUX0
;	REFS0 = Reference Selection Bit (0 -> VCC; 1 -> buildt in ref)
;			0	0	AREV (internal Vref turned off)
;			0	1	AVCC (with ext. Capacitor at AREF)
;			1	0	-
;			1	1	internal 2,56V (with ext. Capacitor at AREF)
;	ADLAR = ADC Left Adjust Result  (0-> right adjust -> low 8:1; high 1:0) 
;	MUX3:0= Analog Channel Select
;		0	0	0	0	ADC0	
;		0	0	0	1	ADC1
;		0	0	1	0	ADC2
;		0	0	1	1	ADC3
;		0	1	0	0	ADC4
;		0	1	0	1	ADC5
;		0	1	1	0	ADC6
;		0	1	1	1	ADC7
;		1	1	1	0	1,30V (VBG)
;		1	1	1	1	0V (Gnd)
; ADC-Routinen
;
; Die UPR wurden fr den Mega 8 entwickelt. bei Verwendung fr andere AVRs ist
; die Kompatibilitt der Register und Steuerbits zu berprfen.
;
;*********************************************************************************
; Interface
;*********************************************************************************
; Name		Input	Output	affected	Funktion
;adc_init	  -		  -		  -			Kanal 0 einstellen, ADC einschalten 
;										Vorteiler 128 fr 16MHz Systemtakt -> 125 kHz
;										Samplefrequenz (13 Takte = 13 mal 8 s = 10 ms)
;adc_get    temp1	AkkuB   AkkuB		Mittelwert von ADC holen
;										in temp1 wird der Zweierexponent fr die 
;										Anzahl von Einzelscans bergeben.
;										0 <= temp1 <= 7
;adc_set_channel \
;			temp1     -       -  		Eingangskanal-Nummer via ADMUX-Register setzen
;										gewnschter Kanal wird in temp1 bergeben
;										Rckmeldung: keine
;*********************************************************************************
;
; ----------------------------------------------------------------------------------------
;
; ADC initialisieren: Single Conversion, Vorteiler 32 -> 250 kHz Samplefrquenz bei 8MHz
; keine Datenbergabe, Register werden nicht verndert
adc_init:
	push r16
    ldi     r16, (0<<REFS1) | (1<<REFS0) | (0<<MUX3) | (0<<MUX2) | (0<<MUX1) | (0<<MUX0)  
    out     ADMUX, r16				; Referenzspannung AVcc, Kanal 0, 
    ldi     r16, (1<<ADEN) | (1<<ADPS2) | (0<<ADPS1) | (1<<ADPS0)
    out     ADCSRA, r16				; 8 MHz / 32 = 250 kHz und einschalten
	sbi		ACSR, ACD				; Analogcomparator aus
	pop r16
    ret

; ----------------------------------------------------------------------------------------

; eine durch R16 vorgegebene Anzahl (2 hoch R16) einzelscanns durchfhren
; und den Mittelwert berechnen.
; Rckgabe des Mittelwerts in Akku B (r3:r5)
adc_get:
	push 	r16
	push 	r17
	push 	r18
	push	r19
	push	r20

    clr     akkub_l
    clr     akkub_m
    clr     akkub_h

 	ldi 	r20, 1			; temp2 zum Potenzieren vorbereiten
	mov		r18, r16		; und temp1 als Zhler speichern
    mov 	r19, r16		; Zweierexponent fr Division merken

	and		r18, 	r18
adc_get0:
	breq 	adc_get1	
	lsl		r20
	dec 	r18
	rjmp 	adc_get0			; Berechne 2 hoch R16

adc_get1:
	; neuen ADC-Wert lesen  (Schleife - 2 hoch r16 mal)
 	; R18 hat mittlerweile den Wert 0
sample_adc:
    sbi     ADCSRA, ADSC        ; den ADC starten (Einzelmessung)
 
wait_adc:
    sbic    ADCSRA, ADSC        ; wenn der ADC fertig ist, wird dieses Bit gelscht
    rjmp    wait_adc
 

	; ADC einlesen:
    in      r16, ADCL         ; immer zuerst LOW Byte lesen
    in      r17, ADCH         ; danach das mittlerweile gesperrte High Byte
 
	; alle ADC-Werte addieren
	; dazu wird mit den Registern akkub_l:h ein
	; 24-Bit breites Akkumulationsregister gebildet, in dem
	; die 10 Bit Werte aus temp1:2 aufsummiert werden
 
    add     akkub_l, r16      ; addieren
    adc     akkub_m, r17      ; addieren ber Carry
    adc     akkub_h, r18      ; addieren ber Carry, R18 enthlt 0
    dec     r20           ; Schleifenzhler MINUS 1
    brne    sample_adc          ; wenn noch keine 2 hoch R16 ADC Werte -> nchsten Wert einlesen
	
	; Aus den 2 hoch R16 Werten den Mittelwert berechnen
	; Mathematisch eine Division durch 2 hoch R16 
	; Das geschieht durch R16 mal rechtsschieben
adc_mittelwert:
	and 	r19, r19
adc_mittelwert1:
	breq	adc_runden
	lsr 	akkub_h
	ror		akkub_m
	ror  	akkub_l
	ror 	r18
	dec 	r19
	brne adc_mittelwert1

	; allerdings wird der Wert noch gerundet
adc_runden:
    cpi     r18,128      		; "Kommastelle" kleiner als 4 ?
    brlo    adc_no_round           	; ist kleiner ==> Sprung, keine Rundung
 
	; Aufrunden
    inc 	akkub_l		      	; addieren von 1
	brne 	adc_no_round	
    inc 	akkub_m 		   ; addieren des Carry
 
adc_no_round:
 	;rjmp warten

	;   Ergebnis steht in akku B
	pop 	r20
	pop 	r19
	pop 	r18
	pop 	r17
	pop 	r16
	ret

; ----------------------------------------------------------------------------------------

; Einstellung des Eingangskanals fr ADC
; Kanalnummer (0..4) wird in temp1 (r16) bergeben
; Rckgabewert: keiner
adc_set_channel:
	push temp2
	in   temp2, sreg
	push temp2

	in temp2, admux
	andi temp2, 0b11110000
	andi temp1, 0b00000111
	or temp2, temp1
	out admux, temp2

	pop temp2
	out sreg, temp2
	pop temp2
	ret
